<?php
// $Id;$

/**
 * Function called when a POST/GET trackback is beeng received
 * @param $nid: the NodeID
 */
function _trackback_receive_post($nid) {
  /*
  if (empty($nid))
    return;
  print(__function__."(". var_export($nid, TRUE).") TODO<br>\n");
  print(__function__."(". var_export($_GET['q'], TRUE).") TODO\n");
  //_trackback_url_to_nid();
  // trackback_received($trackback);
  
  $trackback = trackback_get_object_trackback();
  $trackback->nid = 2;
  $trackback->name = 'NAME'; // The sender site name of this trackback.
  $trackback->subject = "title";
  $trackback->url = "http://somewhere.". $_GET['q'];
  $trackback->excerpt = "Excerpt -- " . $_GET['q'];
  $trackback->status = TRACKBACK_STATUS_SPAM;
  
  // Notify Trackback of received Trackback
  trackback_received($trackback);
  */
  
  // Reading POST data
  // Code taken from  xmlrpc_server() in "includes/xmlrpc.inc")
  $data = file_get_contents('php://input');
  if (!$data) {
    die(t('Trackback Server accepts POST requests only.'));
  }

  $content = explode('; charset=', $_SERVER['CONTENT_TYPE']);
  $trackback = trackback_get_object_trackback();
  $error = new stdClass();
  $error->code = 0;
  
  if (!$content || (is_array($content) && $content[0] != 'application/x-www-form-urlencoded')) {
    $error->message = t('Wrong Content-Type for this request, should be "application/x-www-form-urlencoded".');
    return _trackback_receive_post_return($error);    
  }
  
  if (!trackback_node_enabled($nid)) {
    $error->message = t('This URL cannot be used as a trackback: it is not a trackback-enabled resource.');
    return _trackback_receive_post_return($error);
  }
  if (!isset($_POST['url']) || empty($_POST['url'])) {
    $error-> message = t('Missing source Trackback url.');
    return _trackback_receive_post_return($error);
  }
  else {
    $trackback->url = $_POST['url'];
  }
  
  $error->message = t('Trackback 6.x-2.x-DEV -- UNIMPLEMENTED --');
  return _trackback_receive_post_return($error);
  die();
  
  print_r($GLOBALS);
  $trackback->nid = $nid;
  $trackback->name = '--'; // The sender site name of this trackback.
  $trackback->name = parse_url($pagelinkedfrom, PHP_URL_HOST);
  $trackback->subject = $title;
  $trackback->url = $_POST['url'];
  $trackback->excerpt = $excerpt;
  print_r($trackback);
  die();
}

/**
 * Convert given $string in $encoding format to UTF-8 using a fallback if
 *   $encoding is not setted
 * 
 * @param $string
 * @param $encoding
 * @return Encoded string
 */
function _trackback_convert_to_utf8($string, $encoding = NULL) {
  // @todo: fix this method
  if (!isset($encoding)) {
    $encoding = 'uft-8';
  }
  return drupal_convert_to_utf8($string, $encoding);
}

/**
 * Helper function for returning POST result
 */
function _trackback_receive_post_return($error) {
  header('Content-Type: text/xml');
  $output = array();
  $output[] = '<?xml version="1.0" encoding="utf-8"?>';
  $output[] = '<response>';
  $output[] = '<error>'. $error->code. '</error>';
  if ($error->code == 0) {
    $output[] = '<message>'. $error->message .'</message>';
  }
  $output[] = '</response>';

  print implode("\n", $output);
}

/**
 * XML-RPC callback: process trackback.ping() call.
 * Taken from pingback.module
 */
function _trackback_receive_xmlrpc($pagelinkedfrom, $pagelinkedto) {
  // return xmlrpc_server_error(0, 'abcdefgh');
  // big thanks to WordPress codebase, specifically file xmlrpc.php, method pingback_ping()
  // for becoming the reference implementation and theft victim ;)
  // note: $pagelinkedto is a URL from our own site, $pagelinkedfrom is a foreign URL

  //don't really understand this part, supposed to unescape ampersand entities?
  $pagelinkedfrom = str_replace('&amp;', '&', $pagelinkedfrom);
  $pagelinkedto   = preg_replace('#&([^amp\;])#is', '&amp;$1', $pagelinkedto);
  $error_code = -1;

  // Check if the page linked to is in our site
  $pos1 = strpos($pagelinkedto, str_replace(array('http://www.', 'http://', 'https://www.', 'https://'), '', $GLOBALS['base_url']));
  if (!$pos1) {
    return xmlrpc_server_error(0, t('Is there no link to us?'));
  }

  // let's find which post is linked to
  $nid = _trackback_url_to_nid($pagelinkedto);

  
  $can_receive = trackback_node_enabled($nid);
  
  $node = $nid ? node_load($nid) : FALSE;
  
  if($node && variable_get('trackback_merge_within_translations', TRUE)) {
    // If we keep only the "original" source, send pingbacks only from original node?
    if (isset($node->tnid) && ($node->nid == $node->tnid)) {
      $nid = $node->tnid;
    }
  }
  
  $can_receive = $node->status && $can_receive;
  print $nid;

  die($nid);
  if (!$can_receive) { // node not found
    return xmlrpc_server_error(33, t("The specified target URL cannot be used as a target. It either doesn't exist, or it is not a pingback-enabled resource.". $nid));
  }

  if ($nid == _trackback_url_to_nid($pagelinkedfrom)) {
    return xmlrpc_server_error(0, t('The source URL and the target URL cannot both point to the same resource.'));
  }

  if (!$node->status) {
    return xmlrpc_server_error(33, t("The specified target URL cannot be used as a target. It either doesn't exist, or it is not a pingback-enabled resource (NP)."));
  }

  // Let's check that the remote site didn't already pingback this entry
  if (trackback_exists($nid, $pagelinkedfrom)) { // We already have a Pingback from this URL
    return xmlrpc_server_error(48, 'The pingback has already been registered.');
  }

  // very stupid, but gives time to the 'from' server to publish !
  sleep(1);

  // Let's check the remote site
  $r = drupal_http_request($pagelinkedfrom);
  if ($r->error)
    return xmlrpc_server_error(16, 'The source URL does not exist.');
  $linea = $r->data;

  // Work around bug in strip_tags():
  $linea = str_replace('<!DOC', '<DOC', $linea);
  $linea = preg_replace('/[\s\r\n\t]+/', ' ', $linea); // normalize spaces
  $linea = preg_replace('/ <(h1|h2|h3|h4|h5|h6|p|th|td|li|dt|dd|pre|caption|input|textarea|button|body|br)[^>]*>/', "\n\n", $linea);

  preg_match('|<title>([^<]*?)</title>|is', $linea, $matchtitle);
  $title = check_plain($matchtitle[1]);
  if (empty($title)) {
    return xmlrpc_server_error(32, 'We cannot find a title on that page.');
  }

  $linea = strip_tags($linea, '<a>'); // just keep the tag we need

  $p = explode("\n\n", $linea);

  $preg_target = preg_quote($pagelinkedto);

  foreach ($p as $para) {
    if (strpos($para, $pagelinkedto) !== FALSE) { // it exists, but is it a link?
      preg_match('|<a[^>]+?'. $preg_target .'[^>]*>([^>]+?)</a>|', $para, $context);

      // If the URL isn't in a link context, keep looking
      if (empty($context)) {
        continue;
      }

      // We're going to use this fake tag to mark the context in a bit
      // the marker is needed in case the link text appears more than once in the paragraph
      //I edited <wpcontext></wpcontext> to <dpcontext></dpcontext> so it becomes more Drupal-ish!
      $excerpt = preg_replace('|\</?dpcontext\>|', '', $para);

      // prevent really long link text
      if (drupal_strlen($context[1]) > 100) {
        $context[1] = drupal_substr($context[1], 0, 100) .'...';
      }

      $marker = '<dpcontext>'. $context[1] .'</dpcontext>';    // set up our marker
      $excerpt = str_replace($context[0], $marker, $excerpt); // swap out the link for our marker
      $excerpt = strip_tags($excerpt, '<dpcontext>');        // strip all tags but our context marker
      $excerpt = trim($excerpt);
      $preg_marker = preg_quote($marker);
      $excerpt = preg_replace("|.*?\s(.{0,100}$preg_marker.{0,100})\s.*|s", '$1', $excerpt);
      $excerpt = strip_tags($excerpt); // YES, again, to remove the marker wrapper

      break;
    }
  }

  if (empty($context)) { // Link to target not found
    return xmlrpc_server_error(17, t('The source URL does not contain a link to the target URL, and so cannot be used as a source.'));
  }

  //??? can someone explain about this?
  $pagelinkedfrom = preg_replace('#&([^amp\;])#is', '&amp;$1', $pagelinkedfrom);

  $trackback = trackback_get_object_trackback();
  $trackback->nid = $nid;
  $trackback->name = '--'; // The sender site name of this trackback.
  $trackback->name = parse_url($pagelinkedfrom, PHP_URL_HOST); // Use the domain name
  $trackback->subject = $title;
  $trackback->url = $pagelinkedfrom;
  $trackback->excerpt = $excerpt;
  /*
  //TODO: a custom filter for $excerpt
  $edit = array(
    'nid' => $nid,
    'subject' => t('Pingback'),
    'comment' => '[...] '. $excerpt .' [...]',
    'hostname' => ip_address(),
    'format' => variable_get('pingback_input_format', FILTER_FORMAT_DEFAULT),
    'name' => $title,
    'homepage' => $pagelinkedfrom,
  );
  */
  
  // Notify Trackback of received Trackback
  trackback_received($trackback);
  
  $message = t('Pingback from @source to @target registered! Keep the web talking! :-)', array('@source' => $pagelinkedfrom, '@target' => $pagelinkedto));
  return $message;
}

/**
 * Map any absolute url from this Drupal site to nid if applicable.
 *
 * Can also be used to check whether an absolute path is in the site and points
 * to a node (e.g. node/1).
 * Taken from pingback.module
 */
function _trackback_url_to_nid($url) {
  
  //first check if the url is really in our site, as well as getting the non-base-url part
  if (preg_match($a = '#^'. preg_quote($GLOBALS['base_url'], '#') .'/(.+)$#', $url, $matches)) {
    if (!variable_get('clean_url', 0)) {
      // Clean URLs not enabled. Strip '?q=' from URL.
      $matches[1] = str_replace('?q=', '', $matches[1]);
    }
    
    // VEdere : language_initialize().
    /*
    global $language;
    var_dump($language);
    
    var_export('drupal_get_normal_path:');
    $mio = drupal_get_normal_path('post/drupal-iconizer-module', 'en');
    var_dump($mio);
    $mio = drupal_get_normal_path('en/post/drupal-iconizer-module', 'en');
    var_dump($mio);
    $mio = drupal_get_normal_path('post/drupal-iconizer-module');
    var_dump($mio);    
    $mio = drupal_get_normal_path('post/modulo-drupal-iconizer');
    var_dump($mio);        
    $mio = drupal_get_normal_path($matches[1], 'it');
    var_dump($mio);    
    */
    if (preg_match($b = '#^node/([0-9]+)$#', drupal_get_normal_path($matches[1]), $matches2)) {
      //var_export($matches2[1]);
      return $matches2[1];
    }
  }
  return FALSE;
}

/**

  TODO:  implement pingback.extension.getPingbacks ?

	/**
	 * Retrieve array of URLs that pingbacked the given URL.
	 *
	 * Specs on http://www.aquarionics.com/misc/archives/blogite/0198.html
	 *
	 * @since 1.5.0
	 *
	 * @param array $args Method parameters.
	 * @return array
	 *
	function pingback_extensions_getPingbacks($args) {

		global $wpdb;

		do_action('xmlrpc_call', 'pingback.extensions.getPingsbacks');

		$this->escape($args);

		$url = $args;

		$post_ID = url_to_postid($url);
		if (!$post_ID) {
			// We aren't sure that the resource is available and/or pingback enabled
	  		return new IXR_Error(33, __('The specified target URL cannot be used as a target. It either doesn\'t exist, or it is not a pingback-enabled resource.'));
		}

		$actual_post = wp_get_single_post($post_ID, ARRAY_A);

		if (!$actual_post) {
			// No such post = resource not found
	  		return new IXR_Error(32, __('The specified target URL does not exist.'));
		}

		$comments = $wpdb->get_results( $wpdb->prepare("SELECT comment_author_url, comment_content, comment_author_IP, comment_type FROM $wpdb->comments WHERE comment_post_ID = %d", $post_ID) );

		if (!$comments) {
			return array();
		}

		$pingbacks = array();
		foreach($comments as $comment) {
			if ( 'pingback' == $comment->comment_type )
				$pingbacks[] = $comment->comment_author_url;
		}

		return $pingbacks;
	}

  */